<?php

namespace App\Http\Controllers\Agent;

use App\Http\Controllers\Controller;
use App\Models\Gallery;
use App\Models\Property;
use Illuminate\Http\Request;
use Intervention\Image\Drivers\Gd\Driver as GdDriver;
use Intervention\Image\Exception\NotReadableException;
use Intervention\Image\ImageManager;
use Illuminate\Support\Facades\Validator;

class GalleryController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function show()
    {
        $data[0] = 0;
        $id = $_GET['id'];
        $property = Property::findOrFail($id);
        if (count($property->galleries)) {
            $data[0] = 1;
            $data[1] = $property->galleries;
        }
        return response()->json($data);
    }


    public function store(Request $request)
    {
        $data = [];
        $errors = [];

        $lastid = $request->property_id;

        if (!$request->hasFile('gallery')) {
            return response()->json(['message' => 'No files were uploaded.'], 400);
        }

        $files = $request->file('gallery');

        // GD driver ke saath ImageManager instance
        $manager = new ImageManager(new GdDriver());

        // Final canvas size
        $fixedWidth = 640;
        $fixedHeight = 420;

        // Directory path
        $outsidePath = public_path('assets/images/');
        if (!file_exists($outsidePath)) {
            mkdir($outsidePath, 0777, true);
        }

        foreach ($files as $key => $file) {
            try {
                // ✅ Validate file extension and mime type
                $extension = strtolower($file->getClientOriginalExtension());
                $mime = $file->getMimeType();

                $allowedExtensions = ['jpeg', 'jpg', 'png'];
                $allowedMimes = ['image/jpeg', 'image/jpg', 'image/png'];

                if (!in_array($extension, $allowedExtensions) || !in_array($mime, $allowedMimes)) {
                    $errors[] = [
                        'file' => $file->getClientOriginalName(),
                        'error' => 'Invalid image format. Only JPG and PNG are allowed.'
                    ];
                    continue;
                }

                // ✅ Read image (may throw NotReadableException)
                $original = $manager->read(file_get_contents($file->getPathname()));

                // Resize with aspect ratio
                $originalAspectRatio = $original->width() / $original->height();

                if ($original->height() > $original->width()) {
                    $newHeight = 420;
                    $newWidth = intval($fixedHeight * $originalAspectRatio);
                } else {
                    $newHeight = 420;
                    $newWidth = intval(420 * $originalAspectRatio);
                }

                $resizedOriginal = $original->resize($newWidth, $newHeight, function ($constraint) {
                    $constraint->aspectRatio();
                    $constraint->upsize();
                });

                // Blurred background if needed
                if ($newWidth < $fixedWidth || $newHeight < $fixedHeight) {
                    $blurredBg = clone $original;
                    $blurredBg = $blurredBg->resize($fixedWidth, $fixedHeight)->blur(50);

                    $canvas = $manager->create($fixedWidth, $fixedHeight, '#000000');
                    $canvas->place($blurredBg, 'center');
                    $canvas->place($resizedOriginal, 'center');

                    $finalImage = $canvas;
                } else {
                    $finalImage = $resizedOriginal;
                }

                // Save image
                $filename = uniqid() . '_' . $file->getClientOriginalName();
                $filePath = $outsidePath . $filename;

                file_put_contents($filePath, (string) $finalImage->toJpeg());

                // Save to DB
                $gallery = new Gallery();
                $gallery['photo'] = $filename;
                $gallery['property_id'] = $lastid;
                $gallery->save();

                $data[] = $gallery;
            } catch (NotReadableException $e) {
                $errors[] = [
                    'file' => $file->getClientOriginalName(),
                    'error' => 'Image could not be read or is corrupted.'
                ];
            } catch (\Exception $e) {
                $errors[] = [
                    'file' => $file->getClientOriginalName(),
                    'error' => 'Unexpected error: ' . $e->getMessage()
                ];
            }
        }

        // ✅ Final Response
        if (empty($data) && !empty($errors)) {
            return response()->json([
                'message' => 'Image upload failed for all files.',
                'errors' => $errors
            ], 422);
        }

        return response()->json([
            'uploaded' => $data,
            'errors' => $errors
        ]);
    }


    public function destroy()
    {
        $id = $_GET['id'];
        $gal = Gallery::findOrFail($id);
        @unlink('assets/images/' . $gal->photo);
        $gal->delete();
    }
}
